// Floating Jewelry Elements
const jewelryEmojis = [
    '💍', '💎', '👑', '💍', '💎', '✨',
    '💍', '💎', '👑', '💍', '💎', '✨',
    '💍', '💎', '👑', '💍', '💎', '✨',
    '💍', '💎'
];

function createFloatingJewelry() {
    const container = document.getElementById('floatingJewelry');
    if (!container) return;

    jewelryEmojis.forEach((emoji, index) => {
        const item = document.createElement('div');
        item.className = 'jewelry-item';
        item.textContent = emoji;
        
        // Random position
        item.style.left = `${Math.random() * 100}%`;
        
        // Random animation duration (15-30 seconds)
        const duration = 15 + Math.random() * 15;
        item.style.animationDuration = `${duration}s`;
        
        // Random delay
        item.style.animationDelay = `${Math.random() * 10}s`;
        
        // Random size
        const size = 20 + Math.random() * 20;
        item.style.fontSize = `${size}px`;
        
        container.appendChild(item);
    });
}

// Spotlight Effect
function initSpotlight() {
    const spotlight = document.getElementById('spotlight');
    if (!spotlight) return;

    document.addEventListener('mousemove', (e) => {
        spotlight.style.left = `${e.clientX}px`;
        spotlight.style.top = `${e.clientY}px`;
    });
}

// 3D Card Tilt Effect
function init3DCardTilt() {
    const card = document.getElementById('nftCard');
    if (!card) return;

    card.addEventListener('mousemove', (e) => {
        const rect = card.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        
        const centerX = rect.width / 2;
        const centerY = rect.height / 2;
        
        const rotateX = (y - centerY) / 10;
        const rotateY = (centerX - x) / 10;
        
        card.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) scale3d(1.02, 1.02, 1.02)`;
    });

    card.addEventListener('mouseleave', () => {
        card.style.transform = 'perspective(1000px) rotateX(0) rotateY(0) scale3d(1, 1, 1)';
    });
}

// Wallet Connection Status
let walletConnected = false;
let walletAddress = '';

// Listen for wallet connection from main.js
window.addEventListener('walletConnected', (event) => {
    walletConnected = true;
    walletAddress = event.detail.address;
    updateWalletUI();
});

// Update wallet UI
function updateWalletUI() {
    const walletInput = document.getElementById('walletInput');
    const walletHint = document.getElementById('walletHint');
    const claimButton = document.getElementById('claimButton');
    const connectWalletNav = document.getElementById('connectWalletNav');

    if (walletConnected && walletAddress) {
        // Update input field
        if (walletInput) {
            walletInput.value = walletAddress;
        }

        // Hide hint
        if (walletHint) {
            walletHint.classList.add('hidden');
        }

        // Enable claim button
        if (claimButton) {
            claimButton.disabled = false;
        }

        // Update nav button
        if (connectWalletNav) {
            const shortAddress = `${walletAddress.substring(0, 6)}...${walletAddress.substring(walletAddress.length - 4)}`;
            connectWalletNav.querySelector('.wallet-text').textContent = shortAddress;
            connectWalletNav.style.background = 'rgba(129, 216, 208, 0.2)';
            connectWalletNav.style.borderColor = 'rgba(129, 216, 208, 0.4)';
        }
    } else {
        // Reset UI
        if (walletInput) {
            walletInput.value = '';
        }

        if (walletHint) {
            walletHint.classList.remove('hidden');
        }

        if (claimButton) {
            claimButton.disabled = true;
        }

        if (connectWalletNav) {
            connectWalletNav.querySelector('.wallet-text').textContent = 'Connect Wallet';
            connectWalletNav.style.background = 'rgba(255, 255, 255, 0.1)';
            connectWalletNav.style.borderColor = 'rgba(255, 255, 255, 0.2)';
        }
    }
}

// Form submission (prevent default, your main.js will handle the actual logic)
function initForm() {
    const form = document.getElementById('claimForm');
    if (!form) return;

    form.addEventListener('submit', (e) => {
        e.preventDefault();
        
        if (!walletConnected) {
            alert('Please connect your wallet first');
            return;
        }

        // Your main.js should handle the actual claim logic
        console.log('Claim form submitted');
    });
}

// Countdown animation for status
function updateClaimCount() {
    const statusCount = document.querySelector('.status-count');
    if (!statusCount) return;

    let count = 247;
    setInterval(() => {
        if (Math.random() > 0.7 && count < 1000) {
            count++;
            statusCount.textContent = `${count}/1000 Claimed`;
        }
    }, 5000);
}

// Initialize everything when DOM is loaded
document.addEventListener('DOMContentLoaded', () => {
    createFloatingJewelry();
    initSpotlight();
    init3DCardTilt();
    initForm();
    updateClaimCount();
    updateWalletUI();
});

// Export functions for main.js to use
window.nftApp = {
    setWalletConnected: (address) => {
        walletConnected = true;
        walletAddress = address;
        updateWalletUI();
    },
    disconnectWallet: () => {
        walletConnected = false;
        walletAddress = '';
        updateWalletUI();
    }
};
