# 🚀 Plesk Deployment Instructions for Tiffany & Co NFT Airdrop

## 📦 Files to Upload

Upload these files to your Plesk hosting:

```
/httpdocs/  (or /public_html/)
├── index.php
├── styles.css
├── script.js
├── main.js (your wallet connection file)
├── favicon.png (your Tiffany favicon)
└── main.js.example (reference only - don't need to upload)
```

---

## 🔧 Step-by-Step Deployment to Plesk

### **Method 1: Using Plesk File Manager (Easiest)**

1. **Login to Plesk**
   - Go to: `https://93.185.167.174:8443`
   - Or: `https://your-server-hostname:8443`
   - Login with your credentials

2. **Navigate to File Manager**
   - Click on your domain: `nftiffany.com`
   - Click **"Files"** in the left sidebar
   - Click **"File Manager"**

3. **Go to Web Directory**
   - Navigate to `httpdocs` folder (or `public_html` if that's your web root)
   - This is where your website files go

4. **Upload Files**
   - Click **"Upload"** button
   - Select all files:
     - `index.php`
     - `styles.css`
     - `script.js`
     - `main.js` (your existing file)
     - `favicon.png`
   - Wait for upload to complete

5. **Set Permissions (if needed)**
   - Select `index.php`
   - Click **"Change Permissions"**
   - Set to `644` (read/write for owner, read for others)
   - Repeat for all files

6. **Done!**
   - Visit: `https://nftiffany.com`
   - Your site should now be live! 🎉

---

### **Method 2: Using FTP (FileZilla)**

1. **Get FTP Credentials from Plesk**
   - In Plesk, go to **"Files" > "FTP Access"**
   - Note your FTP username and password
   - Server: `93.185.167.174`
   - Port: `21` (or `22` for SFTP)

2. **Connect with FileZilla**
   - Download FileZilla: https://filezilla-project.org/
   - Host: `ftp://93.185.167.174`
   - Username: Your FTP username
   - Password: Your FTP password
   - Port: `21`
   - Click **"Quickconnect"**

3. **Upload Files**
   - Navigate to `httpdocs` folder on the right panel (server)
   - Drag and drop all files from your local computer (left panel)

4. **Done!**
   - Visit: `https://nftiffany.com`

---

### **Method 3: Using SSH/SFTP (Advanced)**

1. **Connect via SSH**
   ```bash
   ssh your-plesk-user@93.185.167.174
   ```

2. **Navigate to web directory**
   ```bash
   cd /var/www/vhosts/nftiffany.com/httpdocs/
   ```

3. **Upload files using SCP (from your local machine)**
   ```bash
   scp index.php styles.css script.js main.js favicon.png your-user@93.185.167.174:/var/www/vhosts/nftiffany.com/httpdocs/
   ```

4. **Set proper permissions**
   ```bash
   chmod 644 index.php styles.css script.js main.js
   chmod 755 /var/www/vhosts/nftiffany.com/httpdocs/
   ```

---

## 🔒 SSL/HTTPS Setup in Plesk

1. **Go to SSL/TLS Certificates**
   - In Plesk, click on `nftiffany.com`
   - Click **"SSL/TLS Certificates"** in the left sidebar

2. **Install Let's Encrypt (Free SSL)**
   - Click **"Install"** next to Let's Encrypt
   - Check **"Include a 'www' subdomain"**
   - Enter your email address
   - Click **"Install"**
   - Wait 1-2 minutes

3. **Enable HTTPS Redirect**
   - Go to **"Hosting Settings"**
   - Scroll down to **"Security"**
   - Check **"Permanent SEO-safe 301 redirect from HTTP to HTTPS"**
   - Click **"Apply"**

4. **Done!**
   - Your site is now secure with HTTPS
   - Visit: `https://nftiffany.com` 🔒

---

## 🌐 DNS Settings (Cloudflare)

Your DNS should already be set up, but here's the correct configuration:

**In Cloudflare DNS Settings:**

| Type | Name | Content | Proxy Status |
|------|------|---------|--------------|
| A | @ | 93.185.167.174 | Proxied (🟠) |
| A | www | 93.185.167.174 | Proxied (🟠) |

**Cloudflare Settings:**
- **SSL/TLS**: Set to **"Full"** or **"Full (strict)"**
- **Always Use HTTPS**: **ON**
- **Automatic HTTPS Rewrites**: **ON**

---

## 📝 Your main.js Integration

The page expects your `main.js` to handle wallet connections. Here's how to integrate:

### **Option 1: Using the nftApp object**

```javascript
// In your main.js, when wallet connects:
if (window.nftApp) {
    window.nftApp.setWalletConnected('0x1234...5678');
}

// When wallet disconnects:
if (window.nftApp) {
    window.nftApp.disconnectWallet();
}
```

### **Option 2: Using Custom Events**

```javascript
// In your main.js, when wallet connects:
window.dispatchEvent(new CustomEvent('walletConnected', {
    detail: { address: '0x1234...5678' }
}));
```

### **Handling Button Clicks**

Both buttons have the `connect-wallet` class. Add this to your main.js:

```javascript
document.addEventListener('DOMContentLoaded', () => {
    const buttons = document.querySelectorAll('.connect-wallet');
    
    buttons.forEach(button => {
        button.addEventListener('click', () => {
            // Your wallet connection code here
            connectWallet();
        });
    });
});
```

---

## ✅ Verification Checklist

After deployment, check:

- [ ] `https://nftiffany.com` loads correctly
- [ ] Background is Tiffany blue (#81d8d0)
- [ ] Floating jewelry animations are working
- [ ] NFT video is playing
- [ ] Both "Connect Wallet" buttons have the `connect-wallet` class
- [ ] "Claim NFT" button is disabled until wallet connects
- [ ] Favicon appears in browser tab
- [ ] Mouse spotlight effect works
- [ ] 3D card tilt effect works on hover
- [ ] Page is responsive on mobile

---

## 🐛 Troubleshooting

### **Problem: Page shows blank/white screen**

```bash
# Check PHP errors in Plesk
# Go to: Logs > Error Log
```

**Solution:**
- Rename `index.php` to `index.html` if you're not using PHP
- Make sure files are in `httpdocs` folder

---

### **Problem: Styles not loading**

**Check:**
- Files are in the same directory as `index.php`
- File names are exactly: `styles.css` and `script.js` (case-sensitive on Linux)

**Fix permissions:**
```bash
chmod 644 styles.css script.js
```

---

### **Problem: main.js not loading**

**Make sure:**
- `main.js` is in the same directory as `index.php`
- File name is exactly `main.js` (not `main.js.txt`)

**Check browser console:**
- Press `F12` in browser
- Go to **Console** tab
- Look for errors

---

### **Problem: Connect Wallet buttons don't work**

**Check:**
- Your `main.js` is loading (look in browser Console)
- Buttons have the `connect-wallet` class (inspect in browser)
- Your wallet connection code is properly attached

---

## 📊 File Structure on Server

Your final structure should look like:

```
/var/www/vhosts/nftiffany.com/
├── httpdocs/               ← Your website files go here
│   ├── index.php
│   ├── styles.css
│   ├── script.js
│   ├── main.js
│   └── favicon.png
├── logs/
│   ├── access_log          ← Check visitor logs
│   └── error_log           ← Check for errors here
└── statistics/
```

---

## 🎉 You're Done!

Your Tiffany & Co NFT Airdrop page is now live on Plesk!

**Live URL:** https://nftiffany.com

**Features:**
✅ Pure HTML/CSS/JavaScript (no build required)
✅ Works on any standard web hosting (Plesk, cPanel, Apache, Nginx)
✅ Tiffany blue background (#81d8d0)
✅ Floating jewelry animations
✅ 3D card effects
✅ Mouse spotlight effect
✅ Connect Wallet integration
✅ Responsive design
✅ Professional Web3 aesthetic

---

## 📞 Need Help?

Common issues:
1. **500 Error**: Check file permissions (should be 644)
2. **404 Error**: Make sure files are in `httpdocs`
3. **Blank page**: Check error logs in Plesk
4. **JS not working**: Clear browser cache (Ctrl+Shift+R)

Enjoy your professional NFT airdrop page! 💎✨
