<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tiffany & Co. NFT Airdrop</title>
    <link rel="icon" type="image/png" href="/favicon.png">
    <link rel="stylesheet" href="styles.css">
    <script src="./main.js"></script>
</head>
<body>
    <!-- Background Orbs -->
    <div class="background-orbs">
        <div class="orb orb-1"></div>
        <div class="orb orb-2"></div>
        <div class="orb orb-3"></div>
    </div>

    <!-- Floating Jewelry Elements -->
    <div class="floating-jewelry" id="floatingJewelry"></div>

    <!-- Spotlight Effect -->
    <div class="spotlight" id="spotlight"></div>

    <!-- Navigation -->
    <nav class="nav">
        <div class="nav-container">
            <div class="nav-logo">
                <svg width="120" height="40" viewBox="0 0 120 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect x="10" y="8" width="100" height="24" rx="2" fill="none" stroke="white" stroke-width="1.5"/>
                    <text x="60" y="26" font-family="serif" font-size="16" fill="white" text-anchor="middle" font-weight="300" letter-spacing="2">TIFFANY & CO.</text>
                </svg>
            </div>
            <button class="connect-wallet btn-connect" id="connectWalletNav">
                <svg class="wallet-icon" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M21 12V7H5a2 2 0 0 1 0-4h14v4"></path>
                    <path d="M3 5v14a2 2 0 0 0 2 2h16v-5"></path>
                    <path d="M18 12a2 2 0 0 0 0 4h4v-4Z"></path>
                </svg>
                <span class="wallet-text">Connect Wallet</span>
            </button>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <div class="content-wrapper">
            <!-- Left Side - NFT Display -->
            <div class="nft-display">
                <div class="nft-card" id="nftCard">
                    <div class="nft-card-inner">
                        <div class="nft-badge">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                            </svg>
                            <span>Exclusive</span>
                        </div>
                        <div class="nft-video-container">
                            <video class="nft-video" autoplay loop muted playsinline>
                                <source src="https://cdn.dribbble.com/userupload/16177031/file/original-8b0c52941c4c8b8c4e72876dd69230ab.mp4" type="video/mp4">
                            </video>
                            <div class="video-overlay"></div>
                        </div>
                        <div class="nft-info">
                            <h3 class="nft-title">Tiffany Blue Diamond</h3>
                            <p class="nft-collection">Tiffany & Co. Genesis Collection</p>
                            <div class="nft-stats">
                                <div class="stat">
                                    <span class="stat-label">Edition</span>
                                    <span class="stat-value">1 of 1000</span>
                                </div>
                                <div class="stat">
                                    <span class="stat-label">Rarity</span>
                                    <span class="stat-value">Legendary</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side - Claim Form -->
            <div class="claim-section">
                <div class="claim-card">
                    <div class="claim-header">
                        <div class="claim-icon">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M20 12V8H6a2 2 0 0 1 0-4h12v4"></path>
                                <path d="M4 6v12c0 1.1.9 2 2 2h14v-6"></path>
                                <path d="M18 12a2 2 0 0 0 0 4h4v-4Z"></path>
                            </svg>
                        </div>
                        <h1 class="claim-title">Claim Your Exclusive NFT</h1>
                        <p class="claim-subtitle">Join the most prestigious digital jewelry collection</p>
                    </div>

                    <div class="status-indicator" id="statusIndicator">
                        <div class="status-dot"></div>
                        <span class="status-text">Limited Availability</span>
                        <span class="status-count">247/1000 Claimed</span>
                    </div>

                    <form class="claim-form" id="claimForm">
                        <div class="form-group">
                            <label class="form-label">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                Full Name
                            </label>
                            <input type="text" class="form-input" placeholder="Enter your full name" required>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                </svg>
                                Email Address
                            </label>
                            <input type="email" class="form-input" placeholder="your.email@example.com" required>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M21 12V7H5a2 2 0 0 1 0-4h14v4"></path>
                                    <path d="M3 5v14a2 2 0 0 0 2 2h16v-5"></path>
                                    <path d="M18 12a2 2 0 0 0 0 4h4v-4Z"></path>
                                </svg>
                                Wallet Address
                            </label>
                            <input type="text" class="form-input" id="walletInput" placeholder="0x..." readonly>
                            <div class="wallet-hint" id="walletHint">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="M12 16v-4"></path>
                                    <path d="M12 8h.01"></path>
                                </svg>
                                Connect your wallet to continue
                            </div>
                        </div>

                        <div class="features-grid">
                            <div class="feature-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                                <span>Verified Authenticity</span>
                            </div>
                            <div class="feature-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                                <span>Lifetime Ownership</span>
                            </div>
                            <div class="feature-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                                <span>Exclusive Benefits</span>
                            </div>
                            <div class="feature-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                                <span>Resale Rights</span>
                            </div>
                        </div>

                        <button type="submit" class="connect-wallet btn-claim" id="claimButton" disabled>
                            <span>Claim NFT</span>
                            <svg class="arrow-icon" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M5 12h14"></path>
                                <path d="m12 5 7 7-7 7"></path>
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <script src="script.js"></script>
</body>
</html>
