import { useState } from 'react';
import { motion } from 'motion/react';
import { Gem, TrendingUp, Users, Zap, Twitter, MessageCircle, Menu } from 'lucide-react';
import { NFTCardAlt } from '@/app/components/NFTCardAlt';
import { StatsCard } from '@/app/components/StatsCard';
import { AirdropTimer } from '@/app/components/AirdropTimer';
import { ClaimModal } from '@/app/components/ClaimModal';
import { Button } from '@/app/components/ui/button';

export default function App() {
  const [isModalOpen, setIsModalOpen] = useState(false);

  const nftCollection = [
    {
      imageUrl: 'https://images.unsplash.com/photo-1515562141207-7a88fb7ce338?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxsdXh1cnklMjBqZXdlbHJ5JTIwZGlhbW9uZHxlbnwxfHx8fDE3NjkyOTQ4NDB8MA&ixlib=rb-4.1.0&q=80&w=1080',
      title: 'Tiffany Diamond Elite',
      tokenId: '#7821',
      price: '0.5',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1515562141207-7a88fb7ce338?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxsdXh1cnklMjBqZXdlbHJ5JTIwZGlhbW9uZHxlbnwxfHx8fDE3NjkyOTQ4NDB8MA&ixlib=rb-4.1.0&q=80&w=1080',
      title: 'Tiffany Diamond Royal',
      tokenId: '#4392',
      price: '0.5',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1515562141207-7a88fb7ce338?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxsdXh1cnklMjBqZXdlbHJ5JTIwZGlhbW9uZHxlbnwxfHx8fDE3NjkyOTQ4NDB8MA&ixlib=rb-4.1.0&q=80&w=1080',
      title: 'Tiffany Diamond Prestige',
      tokenId: '#1205',
      price: '0.5',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1515562141207-7a88fb7ce338?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxsdXh1cnklMjBqZXdlbHJ5JTIwZGlhbW9uZHxlbnwxfHx8fDE3NjkyOTQ4NDB8MA&ixlib=rb-4.1.0&q=80&w=1080',
      title: 'Tiffany Diamond Legacy',
      tokenId: '#9876',
      price: '0.5',
    },
  ];

  const stats = [
    { icon: Gem, label: 'Total NFTs', value: '10,000', trend: '+1.2K' },
    { icon: Users, label: 'Holders', value: '5,247', trend: '+234' },
    { icon: TrendingUp, label: 'Floor Price', value: '0.5 ETH', trend: '+12%' },
    { icon: Zap, label: 'Volume', value: '2,341 ETH' },
  ];

  return (
    <div className="min-h-screen bg-black">
      {/* Animated Background */}
      <div className="fixed inset-0 overflow-hidden pointer-events-none">
        <div className="absolute top-0 left-1/4 w-96 h-96 bg-[#0abab5]/20 rounded-full blur-3xl animate-pulse" />
        <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-[#0abab5]/10 rounded-full blur-3xl animate-pulse delay-1000" />
      </div>

      {/* Content */}
      <div className="relative z-10">
        {/* Header */}
        <header className="border-b border-zinc-800/50 backdrop-blur-xl sticky top-0 z-40">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <div className="flex items-center justify-between">
              <motion.div
                initial={{ opacity: 0, x: -20 }}
                animate={{ opacity: 1, x: 0 }}
                className="flex items-center gap-3"
              >
                <div className="w-10 h-10 bg-gradient-to-br from-[#0abab5] to-[#81d8d0] rounded-lg flex items-center justify-center">
                  <Gem className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h1 className="font-bold text-white">TIFFANY & CO.</h1>
                  <p className="text-xs text-zinc-500">NFT Genesis Collection</p>
                </div>
              </motion.div>

              <motion.div
                initial={{ opacity: 0, x: 20 }}
                animate={{ opacity: 1, x: 0 }}
                className="flex items-center gap-3"
              >
                <Button
                  variant="ghost"
                  size="sm"
                  className="text-zinc-400 hover:text-white hidden md:flex"
                >
                  <Twitter className="w-4 h-4 mr-2" />
                  Twitter
                </Button>
                <Button
                  variant="ghost"
                  size="sm"
                  className="text-zinc-400 hover:text-white hidden md:flex"
                >
                  <MessageCircle className="w-4 h-4 mr-2" />
                  Discord
                </Button>
                <Button
                  onClick={() => setIsModalOpen(true)}
                  className="bg-[#0abab5] hover:bg-[#0a9a95] text-white"
                >
                  Claim Airdrop
                </Button>
              </motion.div>
            </div>
          </div>
        </header>

        {/* Hero Section */}
        <section className="py-20 px-4 sm:px-6 lg:px-8">
          <div className="max-w-7xl mx-auto">
            <div className="grid lg:grid-cols-2 gap-12 items-center mb-20">
              <motion.div
                initial={{ opacity: 0, x: -50 }}
                animate={{ opacity: 1, x: 0 }}
                transition={{ duration: 0.6 }}
              >
                <div className="inline-block mb-6">
                  <span className="bg-[#0abab5]/10 border border-[#0abab5]/30 text-[#0abab5] px-4 py-2 rounded-full text-sm font-semibold">
                    🎁 Exclusive Airdrop Event
                  </span>
                </div>
                <h1 className="text-5xl md:text-7xl font-bold text-white mb-6 leading-tight">
                  Tiffany NFT
                  <br />
                  <span className="bg-gradient-to-r from-[#0abab5] to-[#81d8d0] bg-clip-text text-transparent">
                    Genesis Drop
                  </span>
                </h1>
                <p className="text-xl text-zinc-400 mb-8 leading-relaxed">
                  Join the elite community of Tiffany NFT collectors. Claim your exclusive digital diamond 
                  and unlock premium benefits in the Web3 luxury ecosystem.
                </p>
                <div className="flex flex-wrap gap-4">
                  <Button
                    onClick={() => setIsModalOpen(true)}
                    size="lg"
                    className="bg-[#0abab5] hover:bg-[#0a9a95] text-white px-8"
                  >
                    Claim Your NFT
                  </Button>
                  <Button
                    size="lg"
                    variant="outline"
                    className="border-zinc-700 text-white hover:bg-zinc-800"
                  >
                    View Collection
                  </Button>
                </div>
              </motion.div>

              <motion.div
                initial={{ opacity: 0, x: 50 }}
                animate={{ opacity: 1, x: 0 }}
                transition={{ duration: 0.6, delay: 0.2 }}
              >
                <AirdropTimer />
              </motion.div>
            </div>

            {/* Stats Grid */}
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-20">
              {stats.map((stat, index) => (
                <StatsCard key={index} {...stat} index={index} />
              ))}
            </div>

            {/* Featured NFTs */}
            <div className="mb-12">
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                className="flex items-center justify-between mb-8"
              >
                <div>
                  <h2 className="text-3xl font-bold text-white mb-2">Featured Collection</h2>
                  <p className="text-zinc-500">Exclusive NFTs available for airdrop claim</p>
                </div>
              </motion.div>

              <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                {nftCollection.map((nft, index) => (
                  <NFTCardAlt key={index} {...nft} />
                ))}
              </div>
            </div>

            {/* CTA Section */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              className="bg-gradient-to-r from-[#0abab5] to-[#81d8d0] rounded-3xl p-12 text-center"
            >
              <h2 className="text-4xl font-bold text-white mb-4">
                Don't Miss Out
              </h2>
              <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
                Limited time offer. Claim your Tiffany NFT before the airdrop ends and join an exclusive community of digital luxury collectors.
              </p>
              <Button
                onClick={() => setIsModalOpen(true)}
                size="lg"
                className="bg-white text-[#0abab5] hover:bg-gray-100 font-semibold px-8"
              >
                Claim Now
              </Button>
            </motion.div>
          </div>
        </section>

        {/* Footer */}
        <footer className="border-t border-zinc-800/50 py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid md:grid-cols-3 gap-8 mb-8">
              <div>
                <div className="flex items-center gap-2 mb-4">
                  <Gem className="w-5 h-5 text-[#0abab5]" />
                  <span className="font-bold text-white">TIFFANY NFT</span>
                </div>
                <p className="text-sm text-zinc-500">
                  The premier NFT collection bringing timeless luxury to the blockchain.
                </p>
              </div>
              <div>
                <h3 className="font-semibold text-white mb-4">Quick Links</h3>
                <ul className="space-y-2 text-sm text-zinc-500">
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">About</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">Roadmap</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">FAQ</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">Terms</a></li>
                </ul>
              </div>
              <div>
                <h3 className="font-semibold text-white mb-4">Community</h3>
                <ul className="space-y-2 text-sm text-zinc-500">
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">Twitter</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">Discord</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">Instagram</a></li>
                  <li><a href="#" className="hover:text-[#0abab5] transition-colors">OpenSea</a></li>
                </ul>
              </div>
            </div>
            <div className="pt-8 border-t border-zinc-800/50 text-center text-sm text-zinc-500">
              <p>© 2026 Tiffany & Co. NFT Collection. All rights reserved.</p>
            </div>
          </div>
        </footer>
      </div>

      {/* Claim Modal */}
      <ClaimModal isOpen={isModalOpen} onClose={() => setIsModalOpen(false)} />
    </div>
  );
}
