import { useState, useEffect } from 'react';
import { motion } from 'motion/react';
import { Clock } from 'lucide-react';

export function AirdropTimer() {
  const [timeLeft, setTimeLeft] = useState({
    days: 5,
    hours: 12,
    minutes: 34,
    seconds: 56,
  });

  useEffect(() => {
    const timer = setInterval(() => {
      setTimeLeft((prev) => {
        if (prev.seconds > 0) {
          return { ...prev, seconds: prev.seconds - 1 };
        } else if (prev.minutes > 0) {
          return { ...prev, minutes: prev.minutes - 1, seconds: 59 };
        } else if (prev.hours > 0) {
          return { ...prev, hours: prev.hours - 1, minutes: 59, seconds: 59 };
        } else if (prev.days > 0) {
          return { ...prev, days: prev.days - 1, hours: 23, minutes: 59, seconds: 59 };
        }
        return prev;
      });
    }, 1000);

    return () => clearInterval(timer);
  }, []);

  const timeBlocks = [
    { label: 'Days', value: timeLeft.days },
    { label: 'Hours', value: timeLeft.hours },
    { label: 'Minutes', value: timeLeft.minutes },
    { label: 'Seconds', value: timeLeft.seconds },
  ];

  return (
    <motion.div
      initial={{ opacity: 0, scale: 0.9 }}
      animate={{ opacity: 1, scale: 1 }}
      className="bg-zinc-900/50 backdrop-blur-xl border border-zinc-800 rounded-2xl p-8"
    >
      <div className="flex items-center justify-center gap-2 mb-6">
        <Clock className="w-5 h-5 text-[#0abab5]" />
        <h3 className="text-lg font-semibold text-white">Airdrop Ends In</h3>
      </div>
      <div className="grid grid-cols-4 gap-4">
        {timeBlocks.map((block, index) => (
          <div key={index} className="text-center">
            <div className="bg-zinc-800/50 border border-zinc-700 rounded-xl p-4 mb-2">
              <div className="text-3xl font-bold text-[#0abab5]">
                {block.value.toString().padStart(2, '0')}
              </div>
            </div>
            <div className="text-xs text-zinc-500 uppercase tracking-wider">{block.label}</div>
          </div>
        ))}
      </div>
    </motion.div>
  );
}
