import { useState } from 'react';
import { motion } from 'motion/react';
import { Gift, Check, Loader2 } from 'lucide-react';
import { Button } from '@/app/components/ui/button';
import { Input } from '@/app/components/ui/input';

export function ClaimSection() {
  const [walletAddress, setWalletAddress] = useState('');
  const [isChecking, setIsChecking] = useState(false);
  const [isEligible, setIsEligible] = useState<boolean | null>(null);
  const [isClaimed, setIsClaimed] = useState(false);

  const handleCheck = () => {
    if (!walletAddress) return;
    
    setIsChecking(true);
    // Mock eligibility check
    setTimeout(() => {
      setIsEligible(true);
      setIsChecking(false);
    }, 1500);
  };

  const handleClaim = () => {
    setIsClaimed(true);
  };

  return (
    <div className="max-w-2xl mx-auto">
      <motion.div
        initial={{ opacity: 0, y: 20 }}
        whileInView={{ opacity: 1, y: 0 }}
        viewport={{ once: true }}
        className="bg-white rounded-3xl shadow-2xl p-8 md:p-12"
      >
        <div className="text-center mb-8">
          <div className="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-[#81d8d0] to-[#0abab5] rounded-full mb-4">
            <Gift className="w-8 h-8 text-white" />
          </div>
          <h2 className="text-3xl font-bold text-gray-900 mb-2">Claim Your NFT</h2>
          <p className="text-gray-600">Check your eligibility and claim your exclusive Tiffany NFT</p>
        </div>

        {!isClaimed ? (
          <div className="space-y-6">
            <div>
              <label className="block text-sm font-medium text-gray-700 mb-2">
                Wallet Address
              </label>
              <Input
                type="text"
                placeholder="0x..."
                value={walletAddress}
                onChange={(e) => setWalletAddress(e.target.value)}
                className="w-full"
                disabled={isEligible !== null}
              />
            </div>

            {isEligible === null ? (
              <Button
                onClick={handleCheck}
                disabled={!walletAddress || isChecking}
                className="w-full bg-[#0abab5] hover:bg-[#0a9a95] text-white h-12"
              >
                {isChecking ? (
                  <>
                    <Loader2 className="w-4 h-4 mr-2 animate-spin" />
                    Checking Eligibility...
                  </>
                ) : (
                  'Check Eligibility'
                )}
              </Button>
            ) : isEligible ? (
              <motion.div
                initial={{ opacity: 0, scale: 0.9 }}
                animate={{ opacity: 1, scale: 1 }}
                className="space-y-4"
              >
                <div className="bg-green-50 border border-green-200 rounded-xl p-4 flex items-start gap-3">
                  <div className="flex-shrink-0 w-6 h-6 bg-green-500 rounded-full flex items-center justify-center mt-0.5">
                    <Check className="w-4 h-4 text-white" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-green-900">You're Eligible!</h3>
                    <p className="text-sm text-green-700 mt-1">
                      Congratulations! You qualify for the Tiffany NFT airdrop.
                    </p>
                  </div>
                </div>
                <Button
                  onClick={handleClaim}
                  className="w-full bg-[#0abab5] hover:bg-[#0a9a95] text-white h-12"
                >
                  <Gift className="w-4 h-4 mr-2" />
                  Claim NFT
                </Button>
              </motion.div>
            ) : (
              <div className="bg-red-50 border border-red-200 rounded-xl p-4">
                <p className="text-sm text-red-700 text-center">
                  Sorry, this wallet is not eligible for the airdrop.
                </p>
              </div>
            )}
          </div>
        ) : (
          <motion.div
            initial={{ opacity: 0, scale: 0.9 }}
            animate={{ opacity: 1, scale: 1 }}
            className="text-center py-8"
          >
            <div className="w-20 h-20 bg-gradient-to-br from-[#81d8d0] to-[#0abab5] rounded-full flex items-center justify-center mx-auto mb-4">
              <Check className="w-10 h-10 text-white" />
            </div>
            <h3 className="text-2xl font-bold text-gray-900 mb-2">NFT Claimed Successfully!</h3>
            <p className="text-gray-600 mb-6">
              Your Tiffany NFT has been sent to your wallet.
            </p>
            <p className="text-sm text-gray-500">
              Transaction: 0x7f9fade1c0d57a7af66ab4ead79fade1c0d57a7af66ab4ead7c2c2eb7b11a91385
            </p>
          </motion.div>
        )}
      </motion.div>
    </div>
  );
}
