import { motion } from 'motion/react';
import { Sparkles } from 'lucide-react';

interface NFTCardProps {
  imageUrl: string;
  title: string;
  edition: string;
  rarity: string;
}

export function NFTCard({ imageUrl, title, edition, rarity }: NFTCardProps) {
  return (
    <motion.div
      initial={{ opacity: 0, y: 20 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{ duration: 0.5 }}
      className="relative group cursor-pointer"
    >
      <div className="bg-white rounded-2xl shadow-lg overflow-hidden border-2 border-gray-100 transition-all duration-300 group-hover:shadow-2xl group-hover:scale-[1.02]">
        <div className="aspect-square overflow-hidden bg-gradient-to-br from-[#81d8d0] to-[#0abab5] relative">
          <img
            src={imageUrl}
            alt={title}
            className="w-full h-full object-cover mix-blend-overlay opacity-80"
          />
          <div className="absolute top-4 right-4 bg-white/90 backdrop-blur-sm px-3 py-1 rounded-full text-xs font-semibold text-[#0abab5] flex items-center gap-1">
            <Sparkles className="w-3 h-3" />
            {rarity}
          </div>
        </div>
        <div className="p-6">
          <h3 className="text-xl font-semibold text-gray-900 mb-1">{title}</h3>
          <p className="text-sm text-gray-500">{edition}</p>
        </div>
      </div>
    </motion.div>
  );
}
