import { motion } from 'motion/react';
import { Crown, ExternalLink } from 'lucide-react';

interface NFTCardAltProps {
  imageUrl: string;
  title: string;
  tokenId: string;
  price: string;
}

export function NFTCardAlt({ imageUrl, title, tokenId, price }: NFTCardAltProps) {
  return (
    <motion.div
      initial={{ opacity: 0, scale: 0.9 }}
      whileInView={{ opacity: 1, scale: 1 }}
      viewport={{ once: true }}
      whileHover={{ y: -10 }}
      transition={{ duration: 0.4 }}
      className="bg-zinc-900/50 backdrop-blur-xl border border-zinc-800 rounded-xl overflow-hidden hover:border-[#0abab5]/50 transition-all duration-300 group"
    >
      <div className="relative aspect-square overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-[#0abab5]/20 to-transparent z-10" />
        <img
          src={imageUrl}
          alt={title}
          className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110"
        />
        <div className="absolute top-4 left-4 z-20">
          <div className="bg-black/60 backdrop-blur-md border border-[#0abab5]/30 px-3 py-1.5 rounded-lg flex items-center gap-2">
            <Crown className="w-3.5 h-3.5 text-[#0abab5]" />
            <span className="text-xs font-medium text-white">Premium</span>
          </div>
        </div>
        <div className="absolute bottom-4 right-4 z-20 opacity-0 group-hover:opacity-100 transition-opacity">
          <button className="bg-[#0abab5] hover:bg-[#0a9a95] text-white p-2 rounded-lg">
            <ExternalLink className="w-4 h-4" />
          </button>
        </div>
      </div>
      <div className="p-5">
        <div className="flex items-start justify-between mb-3">
          <div>
            <h3 className="font-semibold text-white mb-1">{title}</h3>
            <p className="text-xs text-zinc-500">Token ID: {tokenId}</p>
          </div>
        </div>
        <div className="flex items-center justify-between pt-3 border-t border-zinc-800">
          <span className="text-xs text-zinc-500">Airdrop Value</span>
          <span className="text-sm font-semibold text-[#0abab5]">{price} ETH</span>
        </div>
      </div>
    </motion.div>
  );
}
