import { useState } from 'react';
import { motion } from 'motion/react';
import { Wallet, Check } from 'lucide-react';
import { Button } from '@/app/components/ui/button';

export function WalletButton() {
  const [isConnected, setIsConnected] = useState(false);
  const [address, setAddress] = useState('');

  const handleConnect = () => {
    // Mock wallet connection
    setIsConnected(true);
    setAddress('0x742d35Cc6634C0532925a3b844Bc9e7595f0bEb');
  };

  const handleDisconnect = () => {
    setIsConnected(false);
    setAddress('');
  };

  return (
    <motion.div
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      transition={{ delay: 0.2 }}
    >
      {isConnected ? (
        <div className="flex items-center gap-3">
          <div className="bg-white/10 backdrop-blur-sm border border-white/20 rounded-full px-4 py-2 flex items-center gap-2">
            <div className="w-2 h-2 bg-green-400 rounded-full animate-pulse" />
            <span className="text-white text-sm font-medium">
              {address.slice(0, 6)}...{address.slice(-4)}
            </span>
          </div>
          <Button
            onClick={handleDisconnect}
            variant="outline"
            className="bg-white/10 hover:bg-white/20 border-white/20 text-white"
          >
            Disconnect
          </Button>
        </div>
      ) : (
        <Button
          onClick={handleConnect}
          className="bg-white text-[#0abab5] hover:bg-gray-100 font-semibold px-6"
        >
          <Wallet className="w-4 h-4 mr-2" />
          Connect Wallet
        </Button>
      )}
    </motion.div>
  );
}
